#ifndef __COMMON_STRUCT_H_
#define __COMMON_STRUCT_H_

#define ROI_LEVEL_QP_NUM			8
#define VIDEO_ENC_LEVEL_NUM			8
#define VIDEO_BASE_CAP_NUM			8
#define VIDEO_ENC_PARAM_NUM			8
#define DEV_STREAM_NUM				8
#define SCHEDULE_TIME_NUM			256
#define POLGON_AREA_NUM				8
#define POLGON_AREA_PARAM_NUM		8
#define TEMP_ALARM_DEPLOY_NUM		32
#define	ALARM_OUT_NUM				32
#define RECORD_PARAM_NUM			32
#define PTZ_ACTION_PARAM_NUM		32
#define ALARM_LINKAGE_NUM			32
#define OSD_CANVAS_PROPER_NUM		16
#define OSD_INFO_NUM				8
#define NET_PARAM_NUM				4
#define MEASURE_RANGE_NUM			32
#define AREA_INFO_NUM				32
#define SHOW_SCHEDULE_TIME_NUM		32
#define AREA_POINT_NUM				8
#define DISK_ALARM_NUM				8
#define IO_ALARM_NUM				8
#define MOT_OUT_PARAM				8
#define ALARM_INFO_NUM				1024
#define RECORD_POLICY_NUM			2
#define RECORD_DIRECTORY_NUM		8
#define PB_REC_NUM					1024
typedef struct jy_roi_level_qp
{
	int 	level;
	int		qp;
}jy_roi_level_qp_t;

typedef struct jy_roi_ability
{
	int 				support;
	int					max_num;
	int					max_scale;
	int					max_level;
	int 				roi_level_qp_num;
	jy_roi_level_qp_t	roi_level_qp_list[ROI_LEVEL_QP_NUM];
}jy_roi_ability_t;

typedef struct jy_enc_type_level
{
	int 	encoder_level;
}jy_enc_type_level_t;

typedef struct jy_base_cap
{
	char 	size_name[16];
	int		width;
	int		height;
	int		max_fps;
	int		min_fps;
	int		max_bps;
	int		min_bps;
	int		max_qul;
	int		min_qul;
	int		max_inval;
	int		min_inval;
}jy_base_cap_t;

typedef struct jy_video_enc_param
{
	int 				video_enc_type;
	char 				enc_type_name[64];
	int					enc_level_num;
	int					base_cap_num;
	jy_enc_type_level_t	enc_level_list[VIDEO_ENC_LEVEL_NUM];
	jy_base_cap_t		base_cap_list[VIDEO_BASE_CAP_NUM];
}jy_video_enc_param_t;

typedef struct jy_base_stream
{
	int 					stream_id;
	int						video_enc_param_num;
	jy_video_enc_param_t	video_enc_param_list[VIDEO_ENC_PARAM_NUM];
}jy_base_stream_t;

typedef struct jy_video_ability_param
{
	int					channel_id;
	int					base_stream_num;
	jy_base_stream_t	base_stream_list[VIDEO_BASE_CAP_NUM];
}jy_video_ability_param_t;

typedef struct jy_video_ability_param_list
{
	int							param_num;
	jy_video_ability_param_t 	video_param[VIDEO_ENC_PARAM_NUM];
}jy_video_ability_param_list_t;

typedef struct jy_av_stream
{
	int  channel_id;                      ///< channel ID
	int  stream_id;                       ///< stream ID
	int  remote_cam;					  ///< remote Channel
	char stream_name[64];				  ///< stream name
	int  video_height;                    ///< video height
	int  video_width;                     ///< video width
	int  frame_rate;                      ///< frame rate
	int  bit_rate_type;                   ///< rate type, 1:CBR, :VBR
	int  bit_rate;                        ///< bit rate
	int  quality;                         ///< quality
	int  i_frame_interval;                ///< interval
	int  i_frame_interval_unit;           ///< unit
	int  video_encoder_type;              ///< video encoder type
	int  eType_flag;					  ///< changed the encoding type
	int  video_encode_level;              ///< encode level
	int  audio_encoder_type;              ///< audio type
}jy_av_stream_t;

// ȡƵӦ
typedef struct jy_get_av_stream_res
{
	int            stream_num;
	jy_av_stream_t stream[DEV_STREAM_NUM];
}jy_get_av_stream_res_t;

typedef struct jy_snap_picture
{
	int  channel_id;
	int  time_out;
	int  quality;
	char path[128];
}jy_snap_picture_t;

typedef struct jy_stream_param
{
	int  chn_num;
	int  id_num;
	int  chn_list[64];
	int  id_list[4];
}jy_stream_param_t;

typedef struct jy_dev_font_color
{
	int								n_r;
	int								n_g;
	int								n_b;
}jy_dev_font_color_t;

typedef struct jy_dev_osd_global_param
{
	int								time_format_id;
	int								osd_font_alpha;
	int								inverse_flag;
	int								twelve_hours_flag;
	int								week_flag;
	int 							channel_id;
	jy_dev_font_color_t				font_color;
	jy_dev_font_color_t				font_inverse_color;
}jy_dev_osd_global_param_t;

typedef struct jy_dev_area_param
{
	float							top_x;
	float							top_y;
	float							width;
	float							height;
}jy_dev_area_param_t;

typedef struct jy_dev_osd_info
{
	int								area_id;
	int								arrow_id;
	int								type;
	int								enable_flag;
	int								show_mode;
	char 							info[128];
}jy_dev_osd_info_t;

typedef struct jy_dev_canvas_proper
{
	int								front_width;
	int								front_height;
	int								align_mode;
	int								area_id;
	int								osd_info_list_num;
	jy_dev_area_param_t				area_param;
	jy_dev_osd_info_t				osd_info[OSD_INFO_NUM];
}jy_dev_canvas_proper_t;

typedef struct jy_dev_osd_user_param
{
	int								camera_id;
	int								canvas_proper_num;
	jy_dev_osd_global_param_t		osd_global_param;
	jy_dev_canvas_proper_t			canvas_proper_list[OSD_CANVAS_PROPER_NUM];
}jy_dev_osd_user_param_t;

typedef struct jy_video_param
{
	int 	num;
	int		type;
}jy_video_param_t;

typedef struct jy_type_level
{
	int 	num;
	int		level;
}jy_type_level_t;

typedef struct jy_base_param
{
	int 			num;
	jy_base_cap_t	base_cap;
}jy_base_param_t;

typedef struct jy_video_param_list
{
	int 				video_num;
	int					level_num;
	int					base_num;
	jy_video_param_t	video_param[VIDEO_ENC_PARAM_NUM];
	jy_type_level_t		env_level[VIDEO_ENC_LEVEL_NUM];
	jy_base_param_t		base_param[VIDEO_BASE_CAP_NUM];
}jy_video_param_list_t;

typedef struct jy_dev_net_param
{
	int 	m_nNetId;					//Card number
	int 	m_nWorkingType;				//Working type: 1. Public network 2. Camera network 3. binding
	bool 	m_bDHCP;					//DHCP
	char 	m_strLocalIp[32];			//IP
	char 	m_strLocalSubnetMask[32];	//mask
	char 	m_strGateway[32];			//Gateway
	char 	m_strPrimaryDNSIp[32];		//Primary DNS
	char 	m_strSpareDNSIp[32];		//Spare DNS
	int 	m_nIPProtoVer;				//1IPv4 2IPv6
}jy_dev_net_param_t;

typedef struct jy_dev_net_param_list
{
	int 				size;
	jy_dev_net_param_t	net_param[NET_PARAM_NUM];
}jy_dev_net_param_list_t;

typedef struct jy_dev_net_id
{
	int 				size;
	int					id_list[4];
}jy_dev_net_id_t;

typedef enum jy_ip_type_ver_e
{
	JY_IP_TYPE_VER_4 = 1,      ///< IPV4
	JY_IP_TYPE_VER_6 = 2       ///< IPV6
}jy_ip_type_ver_e;

typedef struct jy_dev_port
{
	unsigned short	m_nControlPort;
	unsigned short	m_nTCPAVPort;
	unsigned short	m_nRTSPPort;
	unsigned short	m_nRTPPort;
	unsigned short	m_nRTCPPort;
	unsigned short	m_nRegisterPort;
	unsigned short	m_nHttpPort;
	unsigned short	m_nReservePort1;
	unsigned short	m_nReservePort2;
	unsigned short	m_nReservePort3;
	unsigned short	m_nReservePort4;
	unsigned short	m_nSslControlPort;
	unsigned short	m_nHttpsPort;
}jy_dev_port_t;

typedef struct jy_dev_ai_multi_object_ability
{
	int	face_enable;
	int	upbody_enable;
	int fullbody_enable;
	int plate_enable;
	int vehicle_enable;
}jy_dev_ai_multi_object_ability_t;

typedef struct jy_dev_schedule_time
{
	int	week_day;
	unsigned long start_time;
	unsigned long end_time;
}jy_dev_schedule_time_t;

typedef struct jy_dev_polygon_area
{
	float x_val;
	float y_val;
}jy_dev_polygon_area_t;

typedef struct jy_dev_polygon_area_param
{
	int area_id;
	int face_min_width;
	int face_max_width;
	int polygon_area_size;
	jy_dev_polygon_area_t polygon_area_list[POLGON_AREA_NUM];
}jy_dev_polygon_area_param_t;

typedef struct jy_dev_alarm_out
{
	int action_type;
	int action_id;
	char action_name[32];
	char device_id[16];
	int alarm_out_id;
	int alarm_out_flag;
	int event_type_id;
	int alarm_time;
}jy_dev_alarm_out_t;

typedef struct jy_dev_record_param
{
	int action_type;
	int action_id;
	char action_name[32];
	int pre_record_flag;
	int delay_record_time;
}jy_dev_record_param_t;

typedef struct jy_dev_ptz_action_param
{
	int action_type;
	int action_id;
	char action_name[32];
	int ptz_action_type;
	int ptz_action_id;
	int ptz_chn_id;
}jy_dev_ptz_action_param_t;

typedef struct jy_dev_alarm_linkage
{
	int action_type;
	int action_id;
}jy_dev_alarm_linkage_t;

typedef struct jy_dev_temp_alarm_deployment
{
	int source_type;
	int source_id;
	int alarm_rule;
	int alarm_interval;
	int alarm_threshold;
	int alarm_out_size;
	int record_param_size;
	int ptz_action_size;
	int alarm_linkage_size;
	int schedule_time_size;
	jy_dev_alarm_out_t alarm_out_list[ALARM_OUT_NUM];
	jy_dev_record_param_t record_param_list[RECORD_PARAM_NUM];
	jy_dev_ptz_action_param_t ptz_action_param_list[PTZ_ACTION_PARAM_NUM];
	jy_dev_alarm_linkage_t alarm_linkage_list[ALARM_LINKAGE_NUM];
	jy_dev_schedule_time_t schedule_time_list[SCHEDULE_TIME_NUM];
}jy_dev_temp_alarm_deployment_t;

typedef struct jy_dev_ai_multi_object_param
{
	int	face_enable;
	int	upbody_enable;
	int fullbody_enable;
	int plate_enable;
	int vehicle_enable;
	int yaw_degree;
	int tilt_degree;
	int pitch_degree;
	int snap_picture_mode;
	int snap_picture_num;
	int consume_pictrue_mode;
	int show_object_enable;
	int show_area_enable;
	int ftp_upload_enable;
	int ftp_upload_full_enable;
	int upload_interval;
	int reliabilty;
	int face_min_width;
	int face_max_width;
	int upbody_min_width;
	int upbody_max_width;
	int fullbody_min_width;
	int fullbody_max_width;
	int plate_min_width;
	int plate_max_width;
	int vehicle_min_width;
	int vehicle_max_width;
	int pic_quality;
	int attr_enable;
	int pic_osd_enable;
	int ly_flag;
	int refer_brightness;
	int continue_time;
	int mask_check_enable;
	int live_detection_enable;
	int face_exposure_enable;
	char algo_version[32];
	int schedule_time_size;
	int polygon_area_size;
	int polygon_area_param_size;
	int temp_alarm_deployment_size;
	jy_dev_schedule_time_t schedule_time_list[SCHEDULE_TIME_NUM];
	jy_dev_polygon_area_t polygon_area_list[POLGON_AREA_NUM];
	jy_dev_polygon_area_param_t polygon_area_param_list[POLGON_AREA_PARAM_NUM];
	jy_dev_temp_alarm_deployment_t temp_alarm_deployment_list[TEMP_ALARM_DEPLOY_NUM];
}jy_dev_ai_multi_object_param_t;

typedef struct jy_dev_measure_range
{
	int range_id;
	int max_value;
	int min_value;
}jy_dev_measure_range_t;

typedef struct jy_dev_thermal_cap
{
	int is_thermal;
	int max_measure_area_num;
	int measure_range_size;
	jy_dev_measure_range_t measure_range_list[MEASURE_RANGE_NUM];
}jy_dev_thermal_cap_t;

typedef struct jy_dev_thermal_param
{
	int is_open_tempera_measure;
	int thermal_measure_mode;
	int cur_preset_id;
	int tempr_show_mode;
	float physics_info;
	int display_mode;
	float envit_tempera;
	float cavity_tempera;
	int tempera_unit;
	int is_display_al_area;
	float distance;
	float threshold;
	int abnormal_tempera_filter;
	int ave_tempera_corre;
	int alarm_int;
	int drc_mode;
	int manual_drc_id;
	float manual_drc_range_max;
	float manual_drc_range_min;
	float manual_drc_ori_max;
	float manual_drc_ori_min;
	int measure_rangeid;
	int osd_fontborder_enable;
	int custom_osd_color_enable;
	int fontsize_mode;
	int osd_fontcolor_r;
	int osd_fontcolor_g;
	int osd_fontcolor_b;
	int facecolor_enable;
	int large_enable;
	int large_tempera;
	int largecolor_r;
	int largecolor_g;
	int largecolor_b;
	int range_enable;
	int range_min_tempera;
	int range_max_tempera;
	int range_color_r;
	int range_color_g;
	int range_color_b;
	int small_enable;
	int small_tempera;
	int small_color_r;
	int small_color_g;
	int small_color_b;
	int mix_stream_mode;
	int raw_upload_interval;
	int prevent_overheat_mode;
	int keepclose_duration;
	int control_cover;
	int measure_mode;
	int alarm_delay;
	int length_unit;
	float normal_temp_range_max;
	float normal_temp_range_min;
	int temp_area_mode;
}jy_dev_thermal_param_t;

typedef struct jy_dev_area_id
{
	int area_id;
}jy_dev_area_id_t;

typedef struct jy_dev_thermal_area_tempera_param
{
	int chn_id;
	int area_oper_type;
	int value;
	int area_size;
	jy_dev_area_id_t area_id_list[AREA_INFO_NUM];
}jy_dev_thermal_area_tempera_param_t;

typedef struct jy_dev_area_point
{
	double point_x;
	double point_y;
}jy_dev_area_point_t;

typedef struct jy_dev_area_point_list
{
	int list_size;
	jy_dev_area_point_t area_point[AREA_POINT_NUM];
}jy_dev_area_point_list_t;

typedef struct jy_dev_area_info
{
	int source_id;
	int source_type;
	int area_id;
	char area_name[32];
	int alarm_enable_flag;
	int alarm_type;
	int alarm_max_value;
	int warning_alarm_value;
	int alarm_value;
	float emissivity;
	int target_space;
	int area_en_flag;
	int area_shape_type;
	jy_dev_area_point_list_t area_point_list;
}jy_dev_area_info_t;

typedef struct jy_dev_thermal_area_measure
{
	int measure_mode;
	int preset_id;
	int area_oper_type;
	int chn_id;
	int area_size;
	jy_dev_area_info_t area_info_list[AREA_INFO_NUM];
}jy_dev_thermal_area_measure_t;

typedef struct jy_dev_disk_alarm_param
{
	int source_type;
	int source_id;
	char source_name[32];
	int enable;
	int alarm_interval;
	int full_alarm_enable;
	int alarm_threshold;
	int error_alarm_enable;
	int no_disk_alarm_enable;
	int alarm_out_size;
	int ptz_action_size;
	int alarm_linkage_size;
	int schedule_time_size;
	jy_dev_alarm_out_t alarm_out_list[ALARM_OUT_NUM];
	jy_dev_ptz_action_param_t ptz_action_param_list[PTZ_ACTION_PARAM_NUM];
	jy_dev_alarm_linkage_t alarm_linkage_list[ALARM_LINKAGE_NUM];
	jy_dev_schedule_time_t schedule_time_list[SCHEDULE_TIME_NUM];
}jy_dev_disk_alarm_param_t;

typedef struct jy_dev_disk_alarm_param_list
{
	int								num;
	jy_dev_disk_alarm_param_t		disk_param_list[DISK_ALARM_NUM];
}jy_dev_disk_alarm_param_list_t;

typedef struct jy_dev_io_alarm_param
{
	int source_type;
	int source_id;
	char source_name[32];
	int enable;
	int alarm_interval;
	int valid_level;
	int alarm_out_size;
	int ptz_action_size;
	int alarm_linkage_size;
	int schedule_time_size;
	int record_param_size;
	jy_dev_record_param_t record_param_list[RECORD_PARAM_NUM];
	jy_dev_alarm_out_t alarm_out_list[ALARM_OUT_NUM];
	jy_dev_ptz_action_param_t ptz_action_param_list[PTZ_ACTION_PARAM_NUM];
	jy_dev_alarm_linkage_t alarm_linkage_list[ALARM_LINKAGE_NUM];
	jy_dev_schedule_time_t schedule_time_list[SCHEDULE_TIME_NUM];
}jy_dev_io_alarm_param_t;

typedef struct jy_dev_io_alarm_param_list
{
	int								num;
	jy_dev_io_alarm_param_t			io_param_list[IO_ALARM_NUM];
}jy_dev_io_alarm_param_list_t;

typedef struct jy_dev_show_schedule_time
{
	int								list_size;
	jy_dev_schedule_time_t			schedule_time_list[SHOW_SCHEDULE_TIME_NUM];
}jy_dev_show_schedule_time_t;

typedef struct jy_dev_show_schedule_time_list
{
	int								list_size;
	jy_dev_show_schedule_time_t		show_time_list[7];
}jy_dev_show_schedule_time_list_t;

typedef struct jy_dev_detection_area
{
	int								width_cell_number;
	int								high_cell_number;
	int								data_length;
	char							date[512];
}jy_dev_detection_area_t;

typedef struct jy_dev_mot_detect_param
{
	int								check_block_num;
	int								sensitivity;
	jy_dev_detection_area_t			detect_area;
}jy_dev_mot_detect_param_t;

typedef struct jy_dev_mot_detect_surce_param
{
	int								source_type;
	int								source_id;
	char							source_name[64];
	int								enable_flag;
	int								alarm_interval;
	int								mot_analysis_flag;
	int								schedule_time_size;
	jy_dev_mot_detect_param_t		mot_detect_param;
	jy_dev_schedule_time_t			schedule_time_list[SCHEDULE_TIME_NUM];
}jy_dev_mot_detect_surce_param_t;

typedef struct jy_dev_mot_alarm_param
{
	int								alarm_linkage_size;
	int								ptz_action_size;
	int								alarm_out_size;
	int								record_param_size;
	jy_dev_alarm_linkage_t			alarm_linkage_list[ALARM_LINKAGE_NUM];
	jy_dev_ptz_action_param_t		ptz_action_param_list[PTZ_ACTION_PARAM_NUM];
	jy_dev_alarm_out_t				alarm_out_list[ALARM_OUT_NUM];
	jy_dev_record_param_t			record_param_list[RECORD_PARAM_NUM];
	jy_dev_mot_detect_surce_param_t	mot_source_param;
}jy_dev_mot_alarm_param_t;

typedef struct jy_dev_mot_alarm_param_list
{
	int								num;
	jy_dev_mot_alarm_param_t		mot_alarm_list[MOT_OUT_PARAM];
}jy_dev_mot_alarm_param_list_t;

typedef struct jy_dev_alarm_info
{
	int								alarm_type;
	int								src_id;
	char							alarm_time[24];
}jy_dev_alarm_info_t;

typedef struct jy_dev_get_alarm_list
{
	int								is_more;
	int								num;
	jy_dev_alarm_info_t				alarm_info_list[ALARM_INFO_NUM];
}jy_dev_all_alarm_list_t;

typedef enum jy_dev_alarm_type
{
	ALL_ALARM_TYPE = 0,
	MANUAL_ALARM_TYPE,
	DISK_ALARM_TYPE,
	IO_ALARM_TYPE,
	MOTION_ALARM_TYPE
}jy_dev_alarm_type_t;

typedef struct jy_dev_video_solution
{
	int								video_height;
	int								video_width;
	char							resolution_name[32];
}jy_dev_video_solution_t;

typedef struct jy_dev_snap_shot_para
{
	int								duration;
	int								quality;
	int								interval;
	int								shoot_times;
	jy_dev_video_solution_t			video_solution;
}jy_dev_snap_shot_para_t;

typedef struct jy_dev_record_policy
{
	int								record_open_flag;
	int								record_mode;
	char							dev_id[16];
	int								channel_id;
	int								stream_id;
	int								save_days;
	int								audio_open_flag;
	int								disk_id;
	int								schedule_time_size;
	jy_dev_schedule_time_t			schedule_time_list[SCHEDULE_TIME_NUM];
	jy_dev_snap_shot_para_t			snap_shot_para;
}jy_dev_record_policy_t;

typedef struct jy_dev_record_policy_list
{
	int								num;
	jy_dev_record_policy_t			record_policy_list[RECORD_POLICY_NUM];
}jy_dev_record_policy_list_t;

typedef struct jy_dev_record_directory
{
	int								disk_id;
	int								disk_type;
	int								disk_state;
	int								disk_space;
	int								disk_free_space;
	int								record_flag;
	int								use_days;
	int								record_bitrate;
	int								record_free_space;
	int								snapshot_flag;
	int								snapshot_bitrate;
	int								snapshot_free_space;
}jy_dev_record_directory_t;

typedef struct jy_dev_record_directory_list
{
	int								num;
	jy_dev_record_directory_t		record_directory_list[RECORD_DIRECTORY_NUM];
}jy_dev_record_directory_list_t;

typedef struct jy_dev_pb_rec
{
	char							start_time[24];
	char							end_time[24];
}jy_dev_pb_rec_t;

typedef struct jy_dev_pb_rec_list
{
	int								num;
	jy_dev_pb_rec_t					pb_rec_list[PB_REC_NUM];
}jy_dev_pb_rec_list_t;
#endif //__COMMON_STRUCT_H_